-- new script file

function OnAfterSceneLoaded(self)
  CreateTriggerTargets(self)
  CreateTriggerSources(self)
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true
       
    if not self.loaded then
      self.attackSTactive = false
      self.attackLimit = 540 / Citadels.GetPlayer(0):GetDifficultyCoef()
      self.attackTimer = self.attackLimit
    end
    
    self.attackST:LinkToTarget("attST")
  end
  
  if self.attackSTactive then
    self.td = Timer:GetTimeDiff()
    self.attackTimer = self.attackTimer - self.td
    
    if self.attackTimer <= 0 then
      self.attackLimit = self.attackLimit * 0.9
      self.attackTimer = self.attackLimit
      self.attackST:TriggerAllTargets()
    end  
  end
end

function OnTrigger(self, source, target)
  if target == "activateAttackSt" then
    self.attackSTactive = true
  elseif target == "stopAttackSt" then
    self.attackSTactive = false
  end
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
    CreateTriggerSources(self)
    self.loaded = true
    self.attackSTactive = ar:Read()
    self.attackLimit = ar:Read()
    self.attackTimer = ar:Read()
  elseif (ar:IsSaving()) then
    ar:Write(self.attackSTactive)
    ar:Write(self.attackLimit)
    ar:Write(self.attackTimer)
  end
end

function CreateTriggerTargets(self)
  self:AddTriggerTarget("activateAttackSt")
  self:AddTriggerTarget("stopAttackSt")
end

function CreateTriggerSources(self)
  self:AddTriggerSource("attackST")
end
